from collections import defaultdict

# Vraca (x,y,t) ukoliko se trkaci sretnu, inace None
def collide(ax, ay, dirA, bx, by, dirB):
    # kretanja
    # N: (x, y+t), S: (x, y-t), E: (x+t, y), W: (x-t, y)
    # resavamo jednacinu polaska A i B po t

    # Parametri kretanja A
    if dirA == 'N': Ax, Ay, Avx, Avy = ax, ay, 0, 1
    if dirA == 'S': Ax, Ay, Avx, Avy = ax, ay, 0, -1
    if dirA == 'E': Ax, Ay, Avx, Avy = ax, ay, 1, 0
    if dirA == 'W': Ax, Ay, Avx, Avy = ax, ay, -1,0

    # Parametri kretanja B
    if dirB == 'N': Bx, By, Bvx, Bvy = bx, by, 0, 1
    if dirB == 'S': Bx, By, Bvx, Bvy = bx, by, 0, -1
    if dirB == 'E': Bx, By, Bvx, Bvy = bx, by, 1, 0
    if dirB == 'W': Bx, By, Bvx, Bvy = bx, by, -1,0

    # Jednacine:
    # Ax + t*Avx = Bx + t*Bvx
    # Ay + t*Avy = By + t*Bvy

    # Moramo resiti obe, t >= 0, integer.

    # resimo po X
    if Avx == Bvx:
        if Ax != Bx:
            return None  # nikad se ne poklope
        tx = None  # x jednacina nema informaciju o t
    else:
        num = Bx - Ax
        den = Avx - Bvx
        if num % den != 0:
            return None
        tx = num // den
        if tx < 0:
            return None

    # resimo po Y
    if Avy == Bvy:
        if Ay != By:
            return None
        ty = None
    else:
        num = By - Ay
        den = Avy - Bvy
        if num % den != 0:
            return None
        ty = num // den
        if ty < 0:
            return None

    # sada tz mora biti isti ili None
    if tx is not None and ty is not None and tx != ty:
        return None

    t = tx if tx is not None else ty
    if t is None:
        return None  # identicni pravci, gotovo nikad sudar

    # Koordinate susreta
    X = Ax + t * Avx
    Y = Ay + t * Avy
    return (X, Y, t)


def solve():
    n = int(input())
    pts = [tuple(map(int, input().split())) for _ in range(n)]

    events = defaultdict(int)

    directions = ['N','S','E','W']

    for i in range(n):
        x1, y1 = pts[i]
        for j in range(i+1, n):
            x2, y2 = pts[j]

            # proveri 16 kombinacija (A_dir, B_dir)
            for d1 in directions:
                for d2 in directions:
                    col = collide(x1, y1, d1, x2, y2, d2)
                    if col is not None:
                        events[col] += 2  # 2 trkaca su se srela

    total = 0
    for k in events.values():
        total += k * (k - 1) // 2

    print(total)

solve()